<?php
/**
 * BatchApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Objects\Goals
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Goal Targets
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Objects\Goals\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Crm\Objects\Goals\ApiException;
use HubSpot\Client\Crm\Objects\Goals\Configuration;
use HubSpot\Client\Crm\Objects\Goals\HeaderSelector;
use HubSpot\Client\Crm\Objects\Goals\ObjectSerializer;

/**
 * BatchApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Objects\Goals
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BatchApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'read' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation read
     *
     * Read a batch of goal targets by internal ID, or unique property values
     *
     * @param  \HubSpot\Client\Crm\Objects\Goals\Model\BatchReadInputSimplePublicObjectId $batch_read_input_simple_public_object_id batch_read_input_simple_public_object_id (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['read'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Crm\Objects\Goals\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObject|\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObjectWithErrors|\HubSpot\Client\Crm\Objects\Goals\Model\Error
     */
    public function read($batch_read_input_simple_public_object_id, $archived = false, string $contentType = self::contentTypes['read'][0])
    {
        list($response) = $this->readWithHttpInfo($batch_read_input_simple_public_object_id, $archived, $contentType);
        return $response;
    }

    /**
     * Operation readWithHttpInfo
     *
     * Read a batch of goal targets by internal ID, or unique property values
     *
     * @param  \HubSpot\Client\Crm\Objects\Goals\Model\BatchReadInputSimplePublicObjectId $batch_read_input_simple_public_object_id (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['read'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Crm\Objects\Goals\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObject|\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObjectWithErrors|\HubSpot\Client\Crm\Objects\Goals\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function readWithHttpInfo($batch_read_input_simple_public_object_id, $archived = false, string $contentType = self::contentTypes['read'][0])
    {
        $request = $this->readRequest($batch_read_input_simple_public_object_id, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObject' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObjectWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObjectWithErrors' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObjectWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Crm\Objects\Goals\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Objects\Goals\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Objects\Goals\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObjectWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Objects\Goals\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation readAsync
     *
     * Read a batch of goal targets by internal ID, or unique property values
     *
     * @param  \HubSpot\Client\Crm\Objects\Goals\Model\BatchReadInputSimplePublicObjectId $batch_read_input_simple_public_object_id (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['read'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readAsync($batch_read_input_simple_public_object_id, $archived = false, string $contentType = self::contentTypes['read'][0])
    {
        return $this->readAsyncWithHttpInfo($batch_read_input_simple_public_object_id, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation readAsyncWithHttpInfo
     *
     * Read a batch of goal targets by internal ID, or unique property values
     *
     * @param  \HubSpot\Client\Crm\Objects\Goals\Model\BatchReadInputSimplePublicObjectId $batch_read_input_simple_public_object_id (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['read'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readAsyncWithHttpInfo($batch_read_input_simple_public_object_id, $archived = false, string $contentType = self::contentTypes['read'][0])
    {
        $returnType = '\HubSpot\Client\Crm\Objects\Goals\Model\BatchResponseSimplePublicObject';
        $request = $this->readRequest($batch_read_input_simple_public_object_id, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'read'
     *
     * @param  \HubSpot\Client\Crm\Objects\Goals\Model\BatchReadInputSimplePublicObjectId $batch_read_input_simple_public_object_id (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['read'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function readRequest($batch_read_input_simple_public_object_id, $archived = false, string $contentType = self::contentTypes['read'][0])
    {

        // verify the required parameter 'batch_read_input_simple_public_object_id' is set
        if ($batch_read_input_simple_public_object_id === null || (is_array($batch_read_input_simple_public_object_id) && count($batch_read_input_simple_public_object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_read_input_simple_public_object_id when calling read'
            );
        }



        $resourcePath = '/crm/v3/objects/goal_targets/batch/read';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_read_input_simple_public_object_id)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_read_input_simple_public_object_id));
            } else {
                $httpBody = $batch_read_input_simple_public_object_id;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
